package ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json;

import java.nio.file.Paths;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.ArchiveEntry;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.storage.ByteStorage;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.storage.FileSystemTtlByteStorage;

@Repository
public class FileSystemJsonResponseRepository implements JsonResponseRepository {
    private final ByteStorage storage;

    public FileSystemJsonResponseRepository(
            @Value("${scraper.archive.jsonPath}") String baseDir,
            @Value("${scraper.archive.jsonTtlDays}") Integer storeDays,
            @Value("${scraper.persistentStoragePath:#{null}}") String persistentDir
    )
    {
        if (persistentDir != null) {
            baseDir = persistentDir + "/" + baseDir;
        }
        storage = new FileSystemTtlByteStorage(Paths.get(baseDir), storeDays);
    }

    @Override
    public ArchiveEntry save(String response, String name) {
        return ArchiveEntry.json(storage.save(response.getBytes(), name));
    }

    @Override
    public List<String> entryKeys() {
        return storage.entriesNames();
    }

    @Override
    public String getContent(String id) {
        return new String(storage.getContent(id));
    }

    @Override
    public boolean hasContent(String id) {
        return storage.hasContent(id);
    }
}
