package ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot;

import java.nio.file.Paths;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.ArchiveEntry;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.storage.ByteStorage;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.storage.FileSystemTtlByteStorage;

@Repository
public class FileSystemScreenshotRepository implements ScreenshotRepository {
    private final ByteStorage storage;

    public FileSystemScreenshotRepository(
            @Value("${scraper.archive.screenshotPath}") String baseDir,
            @Value("${scraper.archive.screenshotTtlDays}") Integer storeDays,
            @Value("${scraper.persistentStoragePath:#{null}}") String persistentDir)
    {
        if (persistentDir != null) {
            baseDir = persistentDir + "/" + baseDir;
        }
        storage = new FileSystemTtlByteStorage(Paths.get(baseDir), storeDays);
    }

    @Override
    public ArchiveEntry save(byte[] content, String name) {
        return ArchiveEntry.image(storage.save(content, name));
    }

    @Override
    public byte[] getContent(String id) {
        return storage.getContent(id);
    }

    @Override
    public List<String> entryKeys() {
        return storage.entriesNames();
    }

    @Override
    public boolean hasContent(String id) {
        return storage.hasContent(id);
    }
}
