package ru.yandex.personal.mail.search.metrics.scraper.services.evaluation;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.personal.mail.search.metrics.scraper.metrics.basket.BasketQuery;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.Serp;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpComponent;
import ru.yandex.personal.mail.search.metrics.scraper.metrics.serp.SerpJudgement;

public class SerpEvaluation implements Evaluation {

    @Override
    public List<SerpComponent> markedSerpComponentns(Serp serp, BasketQuery query) {
        return markedComponents(serp.getComponents(), query);
    }

    private List<SerpComponent> markedComponents(List<SerpComponent> components, BasketQuery query) {
        return components.stream().map((sc) -> markComponent(sc, query)).collect(Collectors.toList());
    }

    private SerpComponent markComponent(SerpComponent sc, BasketQuery query) {
        if (query.getRelevantIds().contains(sc.getSerpData().getId())) {
            return sc.withTestResult(SerpJudgement.PASSED);
        } else {
            return sc.withTestResult(SerpJudgement.FAILED);
        }
    }
}
