package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling;

import java.time.Instant;

import com.google.common.base.Stopwatch;

import ru.yandex.personal.mail.search.metrics.scraper.model.crawling.CrawlingMeta;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.WebPageRepresentation;

public final class Crawling {
    private Crawling() {
    }

    public static CrawlingMeta meta(Stopwatch stopwatch, String response) {
        return new CrawlingMeta(stopwatch.elapsed().toMillis(), Instant.now(), response.getBytes().length);
    }

    public static CrawlingMeta meta(Stopwatch stopwatch, WebPageRepresentation representation) {
        return new CrawlingMeta(stopwatch.elapsed().toMillis(), Instant.now(),
                representation.getHtml().getBytes().length);
    }
}
