package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class RetrofitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetrofitUtils.class);

    private RetrofitUtils() {
    }

    public static <T> T executeCall(Call<T> call) {
        Response<T> response;
        try {
            response = call.execute();
        } catch (IOException e) {
            LOG.error("Error executing yandex mobile api call", e);
            throw new CrawlerException(e);
        }

        if (response.isSuccessful()) {
            return response.body();
        } else {
            handleFailedCall(response);
            throw new RuntimeException("unreachable");
        }
    }

    private static <T> void handleFailedCall(Response<T> response) {
        if (response.errorBody() == null) {
            LOG.error("Request is not successful but error body is null");
            throw new CrawlerException("Request is not successful but error body is null");
        } else {
            try {
                LOG.warn("Error using yandex mobile api " + response.errorBody().string());
                throw new CrawlerException(response.errorBody().string());
            } catch (IOException e) {
                throw new CrawlerInternalException(e);
            }
        }
    }
}
