package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters;

import java.util.Iterator;

import ru.yandex.personal.mail.search.metrics.scraper.model.query.SearchQuery;

public class SpellQuerySplitter implements QuerySplitter {
    @Override
    public SplitQuery splitQuery(SearchQuery query) {
        return () -> new SpellPartQueryIterator(query);
    }

    private static class SpellPartQueryIterator implements Iterator<QueryPart> {
        private final String queryText;
        private int currentIndex = 0;

        private SpellPartQueryIterator(SearchQuery query) {
            queryText = query.getText();
        }

        @Override
        public boolean hasNext() {
            return currentIndex < queryText.length();
        }

        @Override
        public QueryPart next() {
            QueryPart result = new QueryPart(
                    queryText.substring(0, currentIndex + 1).intern(),
                    String.valueOf(queryText.charAt(currentIndex))
            );

            currentIndex++;
            return result;
        }
    }
}
