package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium;

import java.util.Random;

// Delays for animations and loading
public enum Delay {
    SMALL(500, 500),
    MEDIUM(2000, 1000),
    BIG(4000, 2000);

    private static Random rnd = new Random();

    private final int minDelay;
    private final int rndDelay;

    Delay(int minDelay, int rndDelay) {
        this.minDelay = minDelay;
        this.rndDelay = rndDelay;
    }

    public void delay() {
        try {
            Thread.sleep(minDelay + rnd.nextInt(rndDelay));
        } catch (InterruptedException ignored) {
        }
    }
}
