package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile("!localDriver")
public class GridWebDriverFactory implements WebDriverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GridWebDriverFactory.class);

    private final URL gridUrl;

    public GridWebDriverFactory(
            @Value("${scraper.crawler.seleniumGridUrl:#{null}}") String gridUrlString
    ) throws MalformedURLException
    {
        if (gridUrlString != null) {
            this.gridUrl = new URL(gridUrlString);
        } else {
            this.gridUrl = null;
        }
    }

    @Override
    public RemoteWebDriver createWebDriver() {
        LOG.trace("Connecting to the web driver on grid");
        ChromeOptions options = new ChromeOptions();
        RemoteWebDriver driver = new RemoteWebDriver(gridUrl, options);
        driver.manage().timeouts().implicitlyWait(SeleniumDriver.FAIL_SAFE_DELAY_SECONDS, TimeUnit.SECONDS);
        return driver;
    }
}
