package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium;

import java.util.concurrent.TimeUnit;

import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile("localDriver")
public class LocalWebDriverFactory implements WebDriverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LocalWebDriverFactory.class);

    public LocalWebDriverFactory(@Value("${scraper.crawler.localDriverPath}") String localDriverPath) {
        System.setProperty("webdriver.gecko.driver", localDriverPath);
    }

    @Override
    public RemoteWebDriver createWebDriver() {
        LOG.debug("Connecting to the local web driver");
        RemoteWebDriver driver = new FirefoxDriver();
        driver.manage().timeouts().implicitlyWait(SeleniumDriver.FAIL_SAFE_DELAY_SECONDS, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(driver::quit));
        return driver;
    }
}
