package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail;

import java.nio.file.Path;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.personal.mail.search.metrics.scraper.services.SystemCredentialValidator;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.html.HtmlResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot.ScreenshotRepository;

public abstract class AbstractSeleniumMailSystemLoader implements SystemCredentialValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSeleniumMailSystemLoader.class);

    private static final String CREDENTIAL = "credentials";

    private final String name;
    private final SeleniumMailClientFactory mailClientFactory;
    private final HtmlResponseRepository responseRepository;
    private final ScreenshotRepository screenshotRepository;

    public AbstractSeleniumMailSystemLoader(
            String name,
            SeleniumMailClientFactory mailClientFactory,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository)
    {
        this.mailClientFactory = mailClientFactory;
        this.name = name;
        this.responseRepository = responseRepository;
        this.screenshotRepository = screenshotRepository;
    }

    @Override
    public boolean supports(String systemName) {
        return name.equals(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return CREDENTIAL.equals(credentialName);
    }

    SeleniumMailClient createMailClient(Path accPath) {
        LOG.trace("Loading mail client for " + name + " from " + accPath.toString());
        return mailClientFactory.createMailClient(accPath, CREDENTIAL);
    }

    ScreenshotRepository getScreenshotRepository() {
        return screenshotRepository;
    }

    HtmlResponseRepository getHtmlResponseRepository() {
        return responseRepository;
    }

    String getSystemName() {
        return name;
    }
}
