package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail;

import java.nio.file.Path;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.html.HtmlResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot.ScreenshotRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.MailSearchParser;

public class SeleniumMailSearchSystemLoader extends AbstractSeleniumMailSystemLoader implements MailSearchSystemLoader {
    private final MailSearchParser parser;

    public SeleniumMailSearchSystemLoader(
            String name,
            SeleniumMailClientFactory mailClientFactory,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            MailSearchParser parser)
    {
        super(name, mailClientFactory, responseRepository, screenshotRepository);
        this.parser = parser;
    }

    @Override
    public MailSearchSystem load(Path accPath) {
        return new SeleniumMailSearchSystem(
                parser,
                createMailClient(accPath),
                getHtmlResponseRepository(),
                getScreenshotRepository(),
                getSystemName());
    }
}
