package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail;

import java.nio.file.Path;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.html.HtmlResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot.ScreenshotRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.MailSuggestParser;

public class SeleniumMailSuggestSystemLoader extends AbstractSeleniumMailSystemLoader implements MailSuggestSystemLoader {
    private final int suggestTimeout;
    private final MailSuggestParser parser;
    private final QuerySplitter querySplitter;

    public SeleniumMailSuggestSystemLoader(
            String name,
            SeleniumMailClientFactory mailClientFactory,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            MailSuggestParser parser,
            QuerySplitter querySplitter,
            int suggestTimeout)
    {
        super(name, mailClientFactory, responseRepository, screenshotRepository);
        this.suggestTimeout = suggestTimeout;
        this.parser = parser;
        this.querySplitter = querySplitter;
    }

    @Override
    public MailSuggestSystem load(Path accPath) {
        return new SeleniumMailSuggestSystem(
                suggestTimeout,
                getSystemName(),
                parser,
                createMailClient(accPath),
                getHtmlResponseRepository(),
                getScreenshotRepository(),
                querySplitter);
    }
}
