package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail;

import com.google.common.base.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class WebElementState {
    private final By locator;
    private final WebElement statedElement;

    public WebElementState(By locator, WebElement statedElement) {
        this.locator = locator;
        this.statedElement = statedElement;
    }

    public By getLocator() {
        return locator;
    }

    public WebElement getStatedElement() {
        return statedElement;
    }

    @Override
    public String toString() {
        return "WebElementState{" +
                "locator=" + locator +
                ", statedElement=" + statedElement +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebElementState that = (WebElementState) o;
        return Objects.equal(locator, that.locator) &&
                Objects.equal(statedElement, that.statedElement);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(locator, statedElement);
    }
}
