package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.gapi;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.gmail.GmailScopes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerException;

public class GApiAuthFlow {
    private static final Logger LOG = LoggerFactory.getLogger(GApiAuthFlow.class);

    private static final List<String> SCOPES = Collections.singletonList(GmailScopes.MAIL_GOOGLE_COM);
    private static final String ACCESS_TYPE = "offline";
    private static final String AUTH_USER = "user";

    private final Path credentialPath;
    private final Path tokenPath;
    private final int port;

    public GApiAuthFlow(
            Path credentialsPath,
            Path tokenPath,
            Integer port
    )
    {
        credentialPath = credentialsPath;
        this.tokenPath = tokenPath;
        this.port = port;
    }

    public Credential getCredentials(NetHttpTransport transport, JacksonFactory jacksonFactory) {
        try (Reader reader = credentialsReader()) {
            LOG.debug("Loading google secrets");
            GoogleClientSecrets secrets = GoogleClientSecrets.load(jacksonFactory, reader);

            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(
                    transport, jacksonFactory, secrets, SCOPES)
                    .setDataStoreFactory(new FileDataStoreFactory(tokenPath.toFile().getAbsoluteFile().getParentFile()))
                    .setAccessType(ACCESS_TYPE)
                    .build();

            LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(port).build();

            LOG.debug("Enabling google authentication flow");
            return new AuthorizationCodeInstalledApp(flow, receiver).authorize(AUTH_USER);
        } catch (IOException e) {
            throw new CrawlerException(e);
        }
    }

    private Reader credentialsReader() {
        try {
            return Files.newBufferedReader(credentialPath);
        } catch (IOException e) {
            LOG.error("Can not read google credentials: " + credentialPath.toString());
            throw new CrawlerException(e);
        }
    }
}
