package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.gapi;

import java.io.IOException;
import java.security.GeneralSecurityException;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerException;

@Configuration
public class GApiConfiguration {
    @Bean
    public JacksonFactory defaultJacksonFactory() {
        return JacksonFactory.getDefaultInstance();
    }

    @Bean
    public NetHttpTransport trustedTransport() {
        try {
            return GoogleNetHttpTransport.newTrustedTransport();
        } catch (GeneralSecurityException | IOException e) {
            throw new CrawlerException(e);
        }
    }
}
