package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.gapi;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

import com.google.api.services.gmail.model.Message;

import ru.yandex.personal.mail.search.metrics.scraper.model.mail.search.MailSearchMessageSnippet;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.ParsingException;

public class GApiMessageToMessageSearchSnippetConverter {
    private static final String GOOGLE_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern(GOOGLE_DATE_PATTERN);

    public MailSearchMessageSnippet convert(Message msg) {
        String sender = findInMessageHeaders(msg, "From").replaceAll("<.*>", "").trim();
        String subject = findInMessageHeaders(msg, "Subject");
        String snippet = msg.getSnippet();
        Instant date = parseMessageDate(msg);

        return new MailSearchMessageSnippet(subject, snippet, sender, date);
    }

    String findInMessageHeaders(Message msg, String key) {
        return msg.getPayload()
                .getHeaders()
                .stream()
                .filter((h) -> h.getName().equals(key))
                .findFirst().orElseThrow(() -> new ParsingException("No 'From' header in msg headers"))
                .getValue();
    }

    Instant parseMessageDate(Message msg) {
        String timestampString = findInMessageHeaders(msg, "Date");
        String cleanTimestampString = timestampString.replaceAll(" \\(.*\\)", "");
        TemporalAccessor ta = DTF.parse(cleanTimestampString);
        return Instant.from(ta);
    }
}
