package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.gapi;

import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.gmail.Gmail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json.JsonResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;

@Service
public class GApiSearchSystemFactory {
    private final Integer port;
    private final String appName;

    private final JacksonFactory defaultFactory;
    private final NetHttpTransport httpTransport;
    private final JsonResponseRepository responseRepository;

    private final ObjectMapper objectMapper;

    @Autowired
    public GApiSearchSystemFactory(
            @Value("${scraper.crawler.googleAuthPort}") Integer port,
            @Value("${spring.application.name}") String appName,
            JacksonFactory defaultFactory,
            NetHttpTransport httpTransport,
            JsonResponseRepository responseRepository,
            ObjectMapper objectMapper)
    {
        this.port = port;
        this.appName = appName;
        this.defaultFactory = defaultFactory;
        this.httpTransport = httpTransport;
        this.responseRepository = responseRepository;
        this.objectMapper = objectMapper;
    }

    public MailSearchSystem createServiceFromFiles(Path credentials, Path token) {
        GApiAuthFlow flow = new GApiAuthFlow(credentials, token, port);
        Credential credential = flow.getCredentials(httpTransport, defaultFactory);

        Gmail gmail = new Gmail.Builder(httpTransport, defaultFactory, credential).setApplicationName(appName).build();
        GApiMessageToMessageSearchSnippetConverter componentConverter =
                new GApiMessageToMessageSearchSnippetConverter();

        return new GApiSearchSystem(gmail, componentConverter, responseRepository, objectMapper);
    }
}
