package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.gapi;

import java.nio.file.Path;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;

@Service
public class GApiSearchSystemLoader implements MailSearchSystemLoader {
    private static final String TOKEN = "StoredCredential";
    private static final String CREDENTIAL = "credentials";

    private final GApiSearchSystemFactory gApiSearchSystemFactory;

    @Autowired
    public GApiSearchSystemLoader(GApiSearchSystemFactory gApiSearchSystemFactory) {
        this.gApiSearchSystemFactory = gApiSearchSystemFactory;
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return TOKEN.equals(credentialName) || CREDENTIAL.equals(credentialName);
    }

    @Override
    public boolean supports(String systemName) {
        return "google".equals(systemName);
    }

    @Override
    public MailSearchSystem load(Path accPath) {
        return gApiSearchSystemFactory.createServiceFromFiles(accPath.resolve(CREDENTIAL), accPath.resolve(TOKEN));
    }
}
