package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.mweb;

import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerException;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.Delay;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.SeleniumDriver;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.WebCredentials;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.LoginSequence;

@Service
public class MWebLoginSequence implements LoginSequence {
    private static final Logger LOG = LoggerFactory.getLogger(MWebLoginSequence.class);

    private static final String MAILRU_LOGIN_URL = "https://account.mail.ru/login/" +
            "?mode=simple&" + "v=2.0.13&" + "type=login&" + "allow_external=1&" +
            "success_redirect=https%3A%2F%2Fe.mailru.ru%2Fmessages%2Finbox%3Fback%3D1&opener=mailru.login";

    private static final String LOGIN_X_PATH = "//input[@autocomplete='username']";
    private static final String LOGIN_BUTTON_X_PATH = "//button[@data-test-id='next-button']";
    private static final String PASSWORD_X_PATH = "//input[@autocomplete='current-password']";
    private static final String PASSWORD_BUTTON_X_PATH = "//button[@data-test-id='submit-button']";

    private static final String ALTERNATIVE_PASSWORD_X_PATH = "//input[@type='password']";
    private static final String ALTERNATIVE_BUTTON_X_PATH = "//button[@data-test-id='submit-button']";

    @Override
    public void login(String url, SeleniumDriver driver, WebCredentials credentials) {
        driver.getUrl(MAILRU_LOGIN_URL);

        try {
            splitLogin(driver, credentials);
        } catch (CrawlerException e) {
            LOG.info("Split login ended with an exception: " + e.getMessage() + " on url: " + driver.getCurrentUrl()
                    + " using joined login");
            joinedLogin(driver, credentials);
        }
        Delay.SMALL.delay();
    }

    private void joinedLogin(SeleniumDriver driver, WebCredentials credentials) {
        driver.sendText(By.xpath(LOGIN_X_PATH), credentials.getLogin());
        driver.sendText(By.xpath(ALTERNATIVE_PASSWORD_X_PATH), credentials.getPassword());
        driver.click(By.xpath(ALTERNATIVE_BUTTON_X_PATH));
    }

    private void splitLogin(SeleniumDriver driver, WebCredentials credentials) {
        driver.sendText(By.xpath(LOGIN_X_PATH), credentials.getLogin());
        driver.click(By.xpath(LOGIN_BUTTON_X_PATH));
        Delay.SMALL.delay();
        driver.sendText(By.xpath(PASSWORD_X_PATH), credentials.getPassword());
        driver.click(By.xpath(PASSWORD_BUTTON_X_PATH));
    }
}
