package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.mweb;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.html.HtmlResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot.ScreenshotRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.SeleniumDriverFactory;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailClientFactory;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailSuggestSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.mweb.search.MailruSearchParser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.mweb.suggest.MailruSuggestParser;

@Configuration
public class MailruClientConfiguration {
    private static final String CONTROLS_XPATHS_RESOURCES = "webconfig/mweb.json";
    private static final String SEARCH_NAME = "mailru";
    private static final String SUGGEST_NAME = "mailru-suggest";
    private static final int SUGGEST_TIMEOUT_SECONDS = 3;

    @Bean
    @Autowired
    SeleniumMailSearchSystemLoader mailruMailSearchServiceLoader(
            SeleniumMailClientFactory mailruMailClientFactory,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            MailruSearchParser parser
    )
    {
        return new SeleniumMailSearchSystemLoader(
                SEARCH_NAME, mailruMailClientFactory, responseRepository, screenshotRepository, parser);
    }

    @Bean
    @Autowired
    SeleniumMailSuggestSystemLoader mailruMailSuggestServiceLoader(
            SeleniumMailClientFactory mailruMailClientFactory,
            MailruSuggestParser parser,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            QuerySplitter querySplitter
    )
    {
        return new SeleniumMailSuggestSystemLoader(SUGGEST_NAME, mailruMailClientFactory,
                responseRepository, screenshotRepository, parser, querySplitter, SUGGEST_TIMEOUT_SECONDS);
    }

    @Bean
    @Autowired
    SeleniumMailClientFactory mailruMailClientFactory(
            SeleniumDriverFactory driverFactory,
            MWebLoginSequence loginSequence,
            ObjectMapper objectMapper)
    {
        return new SeleniumMailClientFactory(
                CONTROLS_XPATHS_RESOURCES,
                driverFactory,
                loginSequence,
                objectMapper
        );
    }
}
