package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.mweb.suggest;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest.MailSuggestSnippet;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.MailSuggestParser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.WebParseTools;

@Service
public class MailruSuggestParser implements MailSuggestParser {
    private static final Logger LOG = LoggerFactory.getLogger(MailruSuggestParser.class);

    private static final String SUGGEST_TABLE_SELECTOR = "span[class*=b-dropdown__list_suggest]";
    private static final String SUGGEST_ITEM_SELECTOR = "div[data-suggest]";

    public List<MailSuggestSnippet> parse(String html) {
        LOG.trace("Parsing mailru response");
        Document page = WebParseTools.prepareVisiblePage(html);

        Element suggestTable = page.selectFirst(SUGGEST_TABLE_SELECTOR);
        if (suggestTable == null) {
            return Collections.emptyList();
        }

        return parseSnippets(suggestTable);
    }

    private List<MailSuggestSnippet> parseSnippets(Element suggestTable) {
        return suggestTable.select(SUGGEST_ITEM_SELECTOR).stream()
                .map(this::parseSnippet)
                .collect(Collectors.toList());
    }

    private MailSuggestSnippet parseSnippet(Element e) {
        return MailSuggestSnippet.simple(e.text());
    }
}
