package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Query;

public interface YApi {
    String SIDE = "side=scraper";
    int SUGGEST_LIMIT = 10;
    String TWO_STEP = "twoSteps=1";


    @GET("/api/async/mail/search?" + SIDE)
    Call<ResponseBody> search(
            @Query("request") String request,
            @Query("suid") Long suid,
            @Query("uid") Long uid,
            @Query("mdb") String mdb
    );

    @GET("/api/async/mail/suggest?" + SIDE + "&" + SUGGEST_LIMIT)
    Call<ResponseBody> suggest(
            @Query("request") String request,
            @Query("suid") Long suid,
            @Query("uid") Long uid,
            @Query("mdb") String mdb
    );

    @GET("/api/async/mail/suggest?" + SIDE + "&" + SUGGEST_LIMIT + "&" + TWO_STEP)
    Call<ResponseBody> suggestTwoSteps(
            @Query("request") String request,
            @Query("suid") Long suid,
            @Query("uid") Long uid,
            @Query("mdb") String mdb,
            @Query("timeout") Integer timeout,
            @Query("status") String status
    );
}
