package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi;

import java.io.IOException;

import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerInternalException;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.RetrofitUtils;

public class YApiUser {
    private static final Logger LOG = LoggerFactory.getLogger(YApiUser.class);

    private final YApiCredentials credentials;
    private final YApi api;

    public YApiUser(YApiCredentials credentials, YApi api) {
        this.credentials = credentials;
        this.api = api;
    }

    public String suggest(String request) {
        LOG.trace("Performing suggest request for " + request);

        Call<ResponseBody> call =
                api.suggest(request, credentials.getSuid(), credentials.getUid(), credentials.getMdb());
        try {
            return RetrofitUtils.executeCall(call).string();
        } catch (IOException e) {
            throw new CrawlerInternalException(e);
        }
    }

    public String search(String request) {
        LOG.trace("Performing search request for " + request);

        Call<ResponseBody> call =
                api.search(request, credentials.getSuid(), credentials.getUid(), credentials.getMdb());
        try {
            return RetrofitUtils.executeCall(call).string();
        } catch (IOException e) {
            throw new CrawlerInternalException(e);
        }
    }
}
