package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountProperties;
import ru.yandex.personal.mail.search.metrics.scraper.services.account.AccountPropertiesLoader;

@Service
public class YApiUserLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YApiUserLoader.class);

    private static final String CREDENTIAL = "credentials";
    private final ObjectMapper mapper;

    public YApiUserLoader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static boolean validateCredentialName(String credentialName) {
        return CREDENTIAL.equals(credentialName);
    }

    public YApiUser loadUser(Path accPath) {
        YApiCredentials credentials = readCredentials(accPath);
        AccountProperties properties = AccountPropertiesLoader.loadProperties(accPath);
        String baseUrl = properties.getHostUrl();
        Retrofit retrofit = yApiRetrofit(baseUrl);

        YApi api = retrofit.create(YApi.class);
        return new YApiUser(credentials, api);
    }

    private Retrofit yApiRetrofit(String url) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        return new Retrofit.Builder()
                .baseUrl(url)
                .addConverterFactory(GsonConverterFactory.create())
                .client(httpClient.build())
                .build();
    }

    private YApiCredentials readCredentials(Path accPath) {
        try {
            return mapper.readValue(accPath.resolve(CREDENTIAL).toFile(), YApiCredentials.class);
        } catch (IOException e) {
            LOG.error("Error reading YApiCredentials", e);
            throw new UncheckedIOException(e);
        }
    }
}
