package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi.suggest;

import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json.JsonResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi.YApiUser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yapi.YApiUserLoader;

@Service
public class YApiSuggestSystemLoader implements MailSuggestSystemLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YApiSuggestSystemLoader.class);

    private final JsonResponseRepository responseRepository;
    private final QuerySplitter querySplitter;
    private final ObjectMapper mapper;
    private final YApiUserLoader userLoader;

    @Autowired
    public YApiSuggestSystemLoader(
            ObjectMapper mapper,
            JsonResponseRepository responseRepository,
            QuerySplitter querySplitter,
            YApiUserLoader userLoader)
    {
        this.mapper = mapper;
        this.responseRepository = responseRepository;
        this.querySplitter = querySplitter;
        this.userLoader = userLoader;
    }

    @Override
    public boolean supports(String systemName) {
        return "yapi-suggest".equals(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return YApiUserLoader.validateCredentialName(credentialName);
    }

    @Override
    public MailSuggestSystem load(Path accPath) {
        LOG.trace("Loading user " + accPath);
        YApiUser user = userLoader.loadUser(accPath);
        return new YApiSuggestSystem(user, responseRepository, querySplitter, mapper);
    }
}
