package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob;

import java.io.IOException;
import java.time.Instant;

import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerInternalException;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.RetrofitUtils;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.UserApi;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.UserApiV2;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.request.SearchRequest;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.request.YMobClient;

public class YMobUser {
    private static final Logger LOG = LoggerFactory.getLogger(YMobUser.class);

    private final YMobCredentials credentials;
    private final UserApi api;
    private final UserApiV2 apiV2;
    private final YMobClient client;

    public YMobUser(YMobCredentials credentials, UserApi api,
            UserApiV2 apiV2,
            YMobClient client)
    {
        this.credentials = credentials;
        this.api = api;
        this.apiV2 = apiV2;
        this.client = client;
    }

    public String search(String query) {
        SearchRequest request = SearchRequest.createDefault(query);
        String reqid = credentials.getUid() + "_" + Instant.now().toEpochMilli();

        LOG.trace("Performing search request for " + query + " with " + reqid);

        Call<ResponseBody> call =
                api.search(client.toString(), credentials.getUuid(), reqid, credentials.getToken(), request);
        try {
            return RetrofitUtils.executeCall(call).string();
        } catch (IOException e) {
            throw new CrawlerInternalException(e);
        }
    }

    public String searchSuggest(String query, int timeout) {
        String reqid = credentials.getUid() + "_" + Instant.now().toEpochMilli();

        LOG.trace("Performing search request for " + query + " with " + reqid);

        Call<ResponseBody> call =
                apiV2.getSearchSuggest(credentials.getToken(), Integer.MAX_VALUE,
                        query, reqid, true, null, timeout, "android", credentials.getUuid());
        try {
            return RetrofitUtils.executeCall(call).string();
        } catch (IOException e) {
            throw new CrawlerInternalException(e);
        }
    }
}
