package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api;


import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Query;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.request.SearchRequest;

public interface UserApi {
    String REQUEST_DISK_ATTACHES_QUERY_PARAM = "request_disk_attaches=1";
    String REQUEST_APP_STATE = "app_state=foreground";

    String HEADER_AUTH = "Authorization";

    @POST("v1/search?" + REQUEST_DISK_ATTACHES_QUERY_PARAM + "&" + REQUEST_APP_STATE)
    Call<ResponseBody> search(
            @Query("client") String client,
            @Query("uuid") String uuid,
            @Query("reqid") String reqid,
            @Header(HEADER_AUTH) String authToken,
            @Body SearchRequest request
    );
}
