package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface UserApiV2 {
    String FOLDER_ID_PARAM = "fid";

    String TAB_PARAM = "tab";

    String MID_PARAM = "mid";

    String MIDS_PARAM = "mids";

    String PATH_PARAM = "path";

    String HID_PARAM = "hid";

    String TEXT_PARAM = "text";

    String LIMIT_PARAM = "limit";

    String REQUEST_PARAM = "request";

    String REQUEST_ID_PARAM = "reqid";

    String TWO_STEPS_PARAM = "twoSteps";

    String STATUS_PARAM = "status";

    String TIMEOUT_PARAM = "timeout";
    String CLIENT_PARAM = "client";
    String UUID_PARAM = "uuid";

    @POST("v2/search_suggest?app_state=foreground")
    Call<ResponseBody> getSearchSuggest(
            @Header(UserApi.HEADER_AUTH) String authToken,
            @Query(LIMIT_PARAM) int limit,
            @Query(TEXT_PARAM) String text,
            @Query(REQUEST_ID_PARAM) String requestId,
            @Query(TWO_STEPS_PARAM) boolean twoSteps,
            @Query(STATUS_PARAM) String status,
            @Query(TIMEOUT_PARAM) int timeout,
            @Query(CLIENT_PARAM) String client,
            @Query(UUID_PARAM) String uuid
    );
}
