package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.request;


import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;

public class SearchRequest {
    private static final int DEFAULT_PAGE_NUMBER = 1;
    private static final int DEFAULT_MESSAGE_LIMIT = 20;

    private String order = "date";

    private String query;

    @JsonAdapter(LongToStringTypeAdapter.class)
    private Long fid = null;

    private String lid = null;

    @SerializedName("page_number")
    private int pageNumber = DEFAULT_PAGE_NUMBER;

    @SerializedName("msg_limit")
    private int msgLimit = DEFAULT_MESSAGE_LIMIT;

    private String unread = null;

    @SerializedName("dont_save")
    private boolean dontSave = true;

    public SearchRequest() {
    }

    public static SearchRequest createDefault(String query) {
        SearchRequest request = new SearchRequest();
        request.query = query;
        return request;
    }

    public static SearchRequest searchFullMail(int pageNumber, int messageLimit, String query) {
        SearchRequest sr = new SearchRequest();
        fillInRequest(pageNumber, messageLimit, query, sr);
        return sr;
    }

    public static SearchRequest searchInFolder(long fid, int pageNumber, int messageLimit, String query) {
        SearchRequest sr = new SearchRequest();
        sr.fid = fid;
        fillInRequest(pageNumber, messageLimit, query, sr);
        return sr;
    }

    public static SearchRequest searchInLabel(String lid, int pageNumber, int messageLimit, String query) {
        SearchRequest sr = new SearchRequest();
        sr.lid = lid;
        fillInRequest(pageNumber, messageLimit, query, sr);
        return sr;
    }

    public static SearchRequest searchInUnread(int pageNumber, int messageLimit, String query) {
        SearchRequest sr = new SearchRequest();
        sr.unread = "yes";
        fillInRequest(pageNumber, messageLimit, query, sr);
        return sr;
    }

    private static SearchRequest fillInRequest(int pageNumber, int messageLimit, String query, SearchRequest sr) {
        sr.pageNumber = pageNumber;
        sr.msgLimit = messageLimit;
        sr.query = query;
        return sr;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Long getFid() {
        return fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public String getLid() {
        return lid;
    }

    public void setLid(String lid) {
        this.lid = lid;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getMsgLimit() {
        return msgLimit;
    }

    public void setMsgLimit(int msgLimit) {
        this.msgLimit = msgLimit;
    }

    public String getUnread() {
        return unread;
    }

    public void setUnread(String unread) {
        this.unread = unread;
    }

    public boolean isDontSave() {
        return dontSave;
    }

    public void setDontSave(boolean dontSave) {
        this.dontSave = dontSave;
    }
}

