package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.api.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class YaMessage {
    public static final int STATUS_READ = 0;
    public static final int STATUS_UNREAD = 1;

    @JsonProperty("mid")
    private Long mid;

    @JsonProperty("fid")
    private Long fid;

    @JsonProperty("lid")
    private List<String> lid;

    // status is 0 for read, 1 for unread, 2 for answered, 3 for forwarded
    @JsonProperty("status")
    private List<Integer> status;

    // UNIX-time
    @JsonProperty("utc_timestamp")
    private long utcTimestamp;

    @JsonProperty("hasAttach")
    private boolean hasAttach;

    @JsonProperty("subjEmpty")
    private boolean subjEmpty;

    @JsonProperty("types")
    private int[] types;

    @JsonProperty("subjPrefix")
    private String subjPrefix;

    @JsonProperty("subjText")
    private String subjText;

    private Recipient from;

    @JsonProperty("firstLine")
    private String firstLine = null;

    @JsonProperty("tab")
    private String tab = null;

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public Long getFid() {
        return fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public List<String> getLid() {
        return lid;
    }

    public void setLid(List<String> lid) {
        this.lid = lid;
    }

    public List<Integer> getStatus() {
        return status;
    }

    public void setStatus(List<Integer> status) {
        this.status = status;
    }

    public long getUtcTimestamp() {
        return utcTimestamp;
    }

    public void setUtcTimestamp(long utcTimestamp) {
        this.utcTimestamp = utcTimestamp;
    }

    public boolean isHasAttach() {
        return hasAttach;
    }

    public void setHasAttach(boolean hasAttach) {
        this.hasAttach = hasAttach;
    }

    public boolean isSubjEmpty() {
        return subjEmpty;
    }

    public void setSubjEmpty(boolean subjEmpty) {
        this.subjEmpty = subjEmpty;
    }

    public int[] getTypes() {
        return types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public String getSubjPrefix() {
        return subjPrefix;
    }

    public void setSubjPrefix(String subjPrefix) {
        this.subjPrefix = subjPrefix;
    }

    public String getSubjText() {
        return subjText;
    }

    public void setSubjText(String subjText) {
        this.subjText = subjText;
    }

    public String getFirstLine() {
        return firstLine;
    }

    public void setFirstLine(String firstLine) {
        this.firstLine = firstLine;
    }

    public String getTab() {
        return tab;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public Recipient getFrom() {
        return from;
    }

    public void setFrom(Recipient from) {
        this.from = from;
    }
}
