package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.longsuggest;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json.JsonResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.YMobUserLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.suggest.YMobSuggestSystemLoader;

@Service
public class YMobLongSuggestSystemLoader extends YMobSuggestSystemLoader {
    @Autowired
    public YMobLongSuggestSystemLoader(
            ObjectMapper mapper,
            JsonResponseRepository responseRepository,
            QuerySplitter querySplitter,
            YMobUserLoader userLoader)
    {
        super(mapper, responseRepository, querySplitter, userLoader);
    }

    @Override
    public boolean supports(String systemName) {
        return "ymob-suggest-4000".equals(systemName);
    }
}
