package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.search;

import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json.JsonResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.YMobUser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.YMobUserLoader;

@Service
public class YMobSearchSystemLoader implements MailSearchSystemLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YMobSearchSystemLoader.class);

    private final ObjectMapper mapper;
    private final JsonResponseRepository responseRepository;
    private final YMobUserLoader userLoader;

    @Autowired
    public YMobSearchSystemLoader(
            ObjectMapper mapper,
            JsonResponseRepository responseRepository,
            YMobUserLoader userLoader)
    {
        this.mapper = mapper;
        this.responseRepository = responseRepository;
        this.userLoader = userLoader;
    }

    @Override
    public boolean supports(String systemName) {
        return "ymob".equals(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return YMobUserLoader.validateCredentialName(credentialName);
    }

    @Override
    public MailSearchSystem load(Path accPath) {
        LOG.trace("Loading user " + accPath);
        YMobUser user = userLoader.loadUser(accPath);
        return new YMobSearchSystem(user, responseRepository, mapper);
    }
}
