package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.suggest;

import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.json.JsonResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystem;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.MailSuggestSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.YMobUser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.ymob.YMobUserLoader;

@Service
public class YMobSuggestSystemLoader implements MailSuggestSystemLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YMobSuggestSystemLoader.class);

    private final JsonResponseRepository responseRepository;
    private final QuerySplitter querySplitter;
    private final ObjectMapper mapper;
    private final YMobUserLoader userLoader;

    @Autowired
    public YMobSuggestSystemLoader(
            ObjectMapper mapper,
            JsonResponseRepository responseRepository,
            QuerySplitter querySplitter,
            YMobUserLoader userLoader)
    {
        this.mapper = mapper;
        this.responseRepository = responseRepository;
        this.querySplitter = querySplitter;
        this.userLoader = userLoader;
    }

    @Override
    public boolean supports(String systemName) {
        return "ymob-suggest".equals(systemName);
    }

    @Override
    public boolean validateCredentialName(String credentialName) {
        return YMobUserLoader.validateCredentialName(credentialName);
    }

    @Override
    public MailSuggestSystem load(Path accPath) {
        LOG.trace("Loading user " + accPath);
        YMobUser user = userLoader.loadUser(accPath);
        return new YMobSuggestSystem(user, responseRepository, mapper, querySplitter);
    }
}
