package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.personal.mail.search.metrics.scraper.services.archive.response.html.HtmlResponseRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.archive.screenshot.ScreenshotRepository;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.suggest.querysplitters.QuerySplitter;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.SeleniumDriverFactory;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailClientFactory;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailSearchSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.SeleniumMailSuggestSystemLoader;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb.search.YaSearchParser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb.suggest.YaSuggestParser;

@Configuration
public class YWebClientConfiguration {
    private static final String SUGGEST_NAME = "yandex-suggest";
    private static final String SEARCH_NAME = "yandex";
    private static final String CONTROLS_XPATHS_RESOURCES = "webconfig/yweb.json";
    private static final int SUGGEST_TIMEOUT_SECONDS = 3;

    @Bean
    @Autowired
    SeleniumMailSearchSystemLoader yandexMailSearchSystemLoader(
            SeleniumMailClientFactory yandexMailClientFactory,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            YaSearchParser parser
    )
    {
        return new SeleniumMailSearchSystemLoader(
                SEARCH_NAME, yandexMailClientFactory, responseRepository, screenshotRepository, parser);
    }

    @Bean
    @Autowired
    SeleniumMailSuggestSystemLoader yandexMailSuggestSystemLoader(
            SeleniumMailClientFactory yandexMailClientFactory,
            YaSuggestParser parser,
            HtmlResponseRepository responseRepository,
            ScreenshotRepository screenshotRepository,
            QuerySplitter querySplitter
    )
    {
        return new SeleniumMailSuggestSystemLoader(SUGGEST_NAME, yandexMailClientFactory,
                responseRepository, screenshotRepository, parser, querySplitter, SUGGEST_TIMEOUT_SECONDS);
    }

    @Bean
    @Autowired
    SeleniumMailClientFactory yandexMailClientFactory(
            SeleniumDriverFactory driverFactory,
            YWebLoginSequence loginSequence,
            ObjectMapper objectMapper)
    {
        return new SeleniumMailClientFactory(
                CONTROLS_XPATHS_RESOURCES,
                driverFactory,
                loginSequence,
                objectMapper
        );
    }
}
