package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb;

import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.crawling.CrawlerException;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.Delay;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.SeleniumDriver;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.WebCredentials;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.selenium.mail.LoginSequence;

@Service
public class YWebLoginSequence implements LoginSequence {
    private static final Logger LOG = LoggerFactory.getLogger(YWebLoginSequence.class);

    private static final String ENTER_BTN_XPATH = "//div[@class='HeadBanner-ButtonsWrapper']/a[2]";
    private static final String LOGIN_XPATH = "//input[@name='login']";
    private static final String LOGIN_BTN_XPATH = "//button[@type='submit']";
    private static final String PASSWORD_XPATH = "//input[@type='password']";
    private static final String PASSWORD_BTN_XPATH = "//button[@type='submit']";
    private static final String JOINED_LOGIN_XPATH = "//form[@class='passport-Domik-Form']/div[1]/label/input";
    private static final String JOINED_PASSWORD_XPATH = "//form[@class='passport-Domik-Form']/div[2]/label/input";
    private static final String JOINED_ENTER_XPATH =
            "//form[@class='passport-Domik-Form']/div[4]/button[@type='submit']";

    @Override
    public void login(String url, SeleniumDriver driver, WebCredentials credentials) {
        driver.getUrl(url);
        driver.click(By.xpath(ENTER_BTN_XPATH));

        try {
            splitLogin(driver, credentials);
        } catch (CrawlerException e) {
            LOG.trace("Split login ended with an exception: " + e.getMessage() + " using joined login");
            joinedLogin(driver, credentials);
        }
    }

    private void splitLogin(SeleniumDriver driver, WebCredentials credentials) {
        driver.sendText(By.xpath(LOGIN_XPATH), credentials.getLogin());
        driver.click(By.xpath(LOGIN_BTN_XPATH));

        Delay.SMALL.delay();

        driver.sendText(By.xpath(PASSWORD_XPATH), credentials.getPassword());
        driver.click(By.xpath(PASSWORD_BTN_XPATH));
    }

    private void joinedLogin(SeleniumDriver driver, WebCredentials credentials) {
        driver.sendText(By.xpath(JOINED_LOGIN_XPATH), credentials.getLogin());
        driver.sendText(By.xpath(JOINED_PASSWORD_XPATH), credentials.getPassword());
        driver.click(By.xpath(JOINED_ENTER_XPATH));
    }
}
