package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb.search;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;

import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.CombinedDateParser;

public class YaDateParser {
    static final Supplier<DateTimeFormatterBuilder> todayFormatterBuilder = () -> new DateTimeFormatterBuilder()
            .appendPattern("сегодня в H:mm")
            .parseDefaulting(ChronoField.DAY_OF_MONTH, LocalDateTime.now().getDayOfMonth())
            .parseDefaulting(ChronoField.MONTH_OF_YEAR, LocalDateTime.now().getMonthValue())
            .parseDefaulting(ChronoField.YEAR, LocalDateTime.now().getYear());
    static final Supplier<DateTimeFormatterBuilder> yesterdayFormatterBuilder = () -> new DateTimeFormatterBuilder()
            .appendPattern("вчера в H:mm")
            .parseDefaulting(ChronoField.DAY_OF_MONTH, LocalDateTime.now().minusDays(1).getDayOfMonth())
            .parseDefaulting(ChronoField.MONTH_OF_YEAR, LocalDateTime.now().minusDays(1).getMonthValue())
            .parseDefaulting(ChronoField.YEAR, LocalDateTime.now().minusDays(1).getYear());
    static final Supplier<DateTimeFormatterBuilder> fullDateFormatterBuilder = () -> new DateTimeFormatterBuilder()
            .appendPattern("dd.MM.")
            .appendValueReduced(ChronoField.YEAR, 2, 2, 2000)
            .appendPattern(" в H:mm");
    private static final String[] SHORT_MONTHS = {"янв", "фев", "мар", "апр", "май", "июн",
            "июл", "авг", "сен", "окт", "ноя", "дек"};
    private static final Map<Long, String> monthNameMap = ImmutableMap.<Long, String>builder()
            .put(1L, "янв")
            .put(2L, "фев")
            .put(3L, "мар")
            .put(4L, "апр")
            .put(5L, "май")
            .put(6L, "июн")
            .put(7L, "июл")
            .put(8L, "авг")
            .put(9L, "сен")
            .put(10L, "окт")
            .put(11L, "ноя")
            .put(12L, "дек")
            .build();
    static final Supplier<DateTimeFormatterBuilder> partialDateFormatterBuilder = () -> new DateTimeFormatterBuilder()
            .appendPattern("d ")
            .appendText(ChronoField.MONTH_OF_YEAR, monthNameMap)
            .appendPattern(" в H:mm")
            .parseDefaulting(ChronoField.YEAR, LocalDateTime.now().getYear());
    private static final CombinedDateParser dateParser = new CombinedDateParser(new Locale("RU", "ru"),
            Lists.newArrayList(partialDateFormatterBuilder, fullDateFormatterBuilder,
                    yesterdayFormatterBuilder, todayFormatterBuilder));

    public Instant parseDateString(String dateString) {
        String purifiedDateString = purifyDateString(dateString);
        return dateParser.parseStringDate(purifiedDateString);
    }

    String purifyDateString(String dateString) {
        return dateString
                .replaceAll("Отправлено ", "")
                .replaceAll("Получено ", "");
    }
}
