package ru.yandex.personal.mail.search.metrics.scraper.services.scraping.systems.yweb.suggest;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.personal.mail.search.metrics.scraper.model.mail.suggest.MailSuggestSnippet;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.MailSuggestParser;
import ru.yandex.personal.mail.search.metrics.scraper.services.scraping.parsing.WebParseTools;

@Service
public class YaSuggestParser implements MailSuggestParser {
    private static final Logger LOG = LoggerFactory.getLogger(YaSuggestParser.class);

    private static final String SUGGEST_TABLE_SELECTOR =
            "div[class=menu menu_size_m menu_theme_normal menu_view_classic mail-SearchSuggest]";
    private static final String CONTROL_ITEM_SELECTOR = "div[class*=control menu__item]";
    private static final String ICON_CONTAINER_SELECTOR = "span[class='mail-IconContainer']";
    private static final String SUGGEST_ITEM_SELECTOR = "div[class='mail-SuggestItem']";

    @Override
    public List<MailSuggestSnippet> parse(String html) {
        LOG.trace("Parsing yandex response");
        Document page = WebParseTools.prepareVisiblePage(html);

        Element suggestTable = page.selectFirst(SUGGEST_TABLE_SELECTOR);
        if (suggestTable == null) {
            return Collections.emptyList();
        }

        return parseSnippets(suggestTable);
    }

    private List<MailSuggestSnippet> parseSnippets(Element suggestTable) {
        return suggestTable.select(CONTROL_ITEM_SELECTOR).stream()
                .map(this::parseSnippet)
                .collect(Collectors.toList());
    }

    private MailSuggestSnippet parseSnippet(Element e) {
        Optional.ofNullable(e.selectFirst(ICON_CONTAINER_SELECTOR)).ifPresent(Node::remove);
        String snippet = e
                .selectFirst(SUGGEST_ITEM_SELECTOR)
                .children()
                .stream()
                .map(Element::text)
                .collect(Collectors.joining(" "));

        return MailSuggestSnippet.simple(snippet);
    }
}
