JAVA_PROGRAM(mail-scraper-service)

JDK_VERSION(11)

UBERJAR()
UBERJAR_PATH_EXCLUDE_PREFIX(META-INF/*.SF META-INF/*.DSA META-INF/*.RSA)

UBERJAR_APPENDING_TRANSFORMER(
    META-INF/spring.handlers
    META-INF/spring.schemas
    META-INF/spring.tooling
    META-INF/cxf/bus-extensions.txt
)

OWNER(g:pslogs)

INCLUDE(versions.inc)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

SET(RETROFIT_VERSION 2.1.0)

PEERDIR(
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
    contrib/java/javax/ws/rs/javax.ws.rs-api
    contrib/java/javax/validation/validation-api
    contrib/java/ru/yandex/qe/commons-bus
    contrib/java/ru/yandex/qe/commons-spring
    contrib/java/ru/yandex/qe/commons-spring-security
    contrib/java/ru/yandex/qe/commons-bus-server
    contrib/java/ru/yandex/qe/commons-json
    contrib/java/ru/yandex/qe/commons-jetty-server
    contrib/java/ru/yandex/qe/commons-standalone
    contrib/java/ru/yandex/qe/commons-util-bundle
    contrib/java/ru/yandex/qe/commons-yt-cypress
    contrib/java/javax/xml/ws/jaxws-api
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/com/ryantenney/metrics/metrics-spring

    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml

    contrib/java/org/hibernate/hibernate-validator
    contrib/java/org/glassfish/javax.el

    contrib/java/org/springframework/retry/spring-retry/1.2.4.RELEASE
    contrib/java/org/springframework/plugin/spring-plugin-core/1.2.0.RELEASE

    contrib/java/com/google/api-client/google-api-client/1.27.0
    contrib/java/com/google/oauth-client/google-oauth-client-jetty/1.28.0
    contrib/java/com/google/apis/google-api-services-gmail/v1-rev103-1.25.0

    contrib/java/org/seleniumhq/selenium/selenium-java/3.7.1
    contrib/java/org/jsoup/jsoup/1.11.3
    contrib/java/com/google/guava/guava/23.0

    contrib/java/com/squareup/retrofit2/retrofit/${RETROFIT_VERSION}
    contrib/java/com/squareup/retrofit2/converter-gson/${RETROFIT_VERSION}
)

EXCLUDE(
    contrib/java/org/mortbay/jetty/servlet-api
    contrib/java/org/slf4j/slf4j-simple
    contrib/java/org/slf4j/jcl-over-slf4j
    contrib/java/org/codehaus/woodstox/woodstox-core-asl
    contrib/java/aopalliance/aopalliance
    contrib/java/org/slf4j/slf4j-simple
    contrib/java/org/hamcrest/hamcrest-all
    contrib/java/org/hamcrest/hamcrest-core
    contrib/java/org/slf4j/log4j-over-slf4j
    contrib/java/javax/activation/javax.activation-api
)

LINT(strict)
CHECK_JAVA_DEPS(yes)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/javax/ws/rs/javax.ws.rs-api/2.1
    contrib/java/javax/xml/ws/jaxws-api/2.3.1
    contrib/java/javax/xml/bind/jaxb-api/2.4.0-b180830.0359
    contrib/java/com/ryantenney/metrics/metrics-spring/3.1.3
)

END()

RECURSE_FOR_TESTS(
    ut
)
