import argparse

import json
from initializr.api import *


def add_acc(host, account):
    system = account["system"]
    name = account["name"]

    # props = json.loads(account["properties"])
    response = account_init(host, system, name, account["properties"])
    if response.status_code != 200:
        assert response.status_code == 400
        print("Account " + name + " already created in " + system)
        return

    for secret in account["secrets"]:
        secret_name = secret["name"]
        secret_path = secret["path"]
        with open(secret_path, 'rb') as binary:
            assert send_part(host, system, name, secret_name, binary).status_code == 200
    assert publish_acc(host, system, name).status_code == 200
    print("Account " + name + " created in " + system)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-c', '--config', required=True)
    args = parser.parse_args()

    with open(args.config, 'r') as f:
        config = json.load(f)

    for account in config["accounts"]:
        add_acc(config["url"], account)


if __name__ == '__main__':
    main()
