import json
import logging
import time
import requests

search_handle = '/api/v1/search'


def __construct_search_url(url, sys, acc):
    return '{}{}/{}/{}'.format(url, search_handle, sys, acc)


def __search_acc(url, sys, acc, query):
    return requests.post(__construct_search_url(url, sys, acc), data=json.dumps(query),
                         headers={'Content-Type': 'application/json'}, verify=False)


def search_with_retries(url, sys, acc, query, retries, timeout):
    error = None
    for i in range(0, retries):
        try:
            response = __search_acc(url, sys, acc, query)
            if response.status_code != 200:
                raise Exception('Status code is not 200: sc: {}, response: {}, headers: {}'
                                .format(response.status_code, response.text, response.headers))
            return response
        except Exception as e:
            logging.exception('Scraping exception occurred', e)
            logging.error('Exception happened on %i long iteration, entering timeout %i s', i, timeout)
            time.sleep(timeout)
            error = e
    raise error
