#!/bin/bash
set -exo pipefail
source recommended_java_args.sh
source classpath.sh
source address_ljinx.gc.args.sh

export TVM_API_HOST=https://tvm-api.yandex.net

export LJINX_WORKERS=10
export GEOCODER_TVM_ID=2001886


export NANNY_SERVICE_ID=$(cat dump.json | jq -r .properties.NANNY_SERVICE_ID)

case "$NANNY_SERVICE_ID" in
  *_prod*)
    export TVM_CLIENT_ID=2001241
    export DATASYNC_TVM_ID=132
    export DATASYNC_HOST="http://intapi.disk.yandex.net:8080"
        ;;
  *_test*)
    export TVM_CLIENT_ID=2001207
    export DATASYNC_TVM_ID=2000060
    export DATASYNC_HOST="http://api-stable.dst.yandex.net:8080"
        ;;
esac

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $ADDRESS_JAVA_ARGS \
    -cp $CLASSPATH -Djava.library.path=address_ljinx ru.yandex.ljinx.Ljinx address_ljinx.conf