#!/bin/bash
set -ex
source address_proxy_config.sh
source classpath.sh
export JAVA_HOME="$BSCONFIG_IDIR/jdk"
BSCONFIG_IDIR=${BSCONFIG_IDIR:-"$PWD"}

JAVA_PID=$(ps aux | grep java | grep -v grep | awk '{print $2}')
PASSPORT_PG_PASSWORD=$(cat /proc/$JAVA_PID/environ | tr '\0' '\n' | egrep -o "^PASSPORT_PG_PASSWORD\=(.+)" | cut -d'=' -f2)

exec $BSCONFIG_IDIR/jdk/bin/java -cp $CLASSPATH \
 liquibase.integration.commandline.Main \
 --changeLogFile $1 \
 --url $PASSPORT_JDBC_URL \
 --username $PASSPORT_PG_USER \
 --password $PASSPORT_PG_PASSWORD \
 $2
