#!/bin/bash
set -exo pipefail
source recommended_java_args.sh
source classpath.sh
source address_proxy.gc.args.sh
source address_proxy_config.sh

export TVM_API_HOST=https://tvm-api.yandex.net

export LJINX_WORKERS=2
export ADDRESS_APP_PORT=81
export ADDRESS_APP_DEBUG_PORT=82
ADDRESS_JAVA_ARGS="-showversion -server -Xverify:none \
 -XX:+AlwaysActAsServerClassMachine -XX:+PerfDisableSharedMem \
 -XX:ErrorFile=/logs/pers-address.hs_err.log \
  -Dfile.encoding=UTF-8 -Dhost.name=$(hostname -s) -Dhost.fqdn=$(hostname -f) \
  -Dapp.name=pers-address -Denvironment=$ENVIROMENT -Ddatacenter=$DC \
  -Dyandex.environment.type=$ENVIROMENT \
  -Dconfigs.path=$BSCONFIG_IDIR/properties.d \
  -Dapp.dir=$BSCONFIG_IDIR \
  -Ddata.dir=/persistent-data -Dext.data.dir=$BSCONFIG_IDIR/data-getter \
  -Dlog.dir=/logs
  -Doracle.net.tns_admin=$BSCONFIG_IDIR/properties.d \
  -Dlog4j2.contextSelector=org.apache.logging.log4j.core.async.AsyncLoggerContextSelector \
  -Dcpu.count=$CPU_CORES -Dhttp.port=$ADDRESS_APP_PORT -Ddebug.port=$ADDRESS_APP_DEBUG_PORT \
  -Djava.library.path=$BSCONFIG_IDIR/address_proxy:$BSCONFIG_IDIR/lib -Djna.library.path=$BSCONFIG_IDIR/lib \
  -XX:MetaspaceSize=128M -Dsun.net.client.defaultConnectTimeout=10000 \
  -Dsun.net.client.defaultReadTimeout=10000 -Dhttp.keepAlive=false \
  -Dspring.profiles.active= \
  -Dlog4j2.contextSelector=org.apache.logging.log4j.core.async.AsyncLoggerContextSelector \
  -Dlog4j.configurationFile=$BSCONFIG_IDIR/conf/log4j2.xml"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $ADDRESS_JAVA_ARGS \
    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
    ru.yandex.ljinx.Ljinx address_proxy_ljinx.conf ";" \
	  ru.yandex.passport.AddressProxy $ADDRESS_PROXY_CONFIG
    #-cp $CLASSPATH ru.yandex.ljinx.Ljinx address_proxy_ljinx.conf