package ru.yandex.passport;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotImplementedException;
import ru.yandex.http.util.ServerException;
import ru.yandex.passport.address.AddressBuilder;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.ListAddressContext;
import ru.yandex.passport.address.PassportAddressBuilder;

public interface AddressStorage<T extends AddressBuilder> {
    void list(final ListAddressContext context, final FutureCallback<List<T>> callback);

    void get(final AddressContext context, final AddressId id, final FutureCallback<T> callback);

    default void create(
        final AddressContext context,
        final PassportAddressBuilder address,
        final FutureCallback<PassportAddressBuilder> callback)
    {
        callback.failed(new NotImplementedException("Create method not allowed for this storage"));
    }

    default void update(
        final AddressContext context,
        final PassportAddressBuilder address,
        final FutureCallback<PassportAddressBuilder> callback)
    {
        callback.failed(new NotImplementedException("Create method not allowed for this storage"));
    }

    default void delete(
        final AddressContext context,
        final AddressId id,
        final FutureCallback<Object> callback)
    {
        callback.failed(new NotImplementedException("Create method not allowed for this storage"));
    }

    default void hidden(final AddressContext context, final FutureCallback<Set<AddressId>> callback) {
        callback.completed(Collections.emptySet());
    }

    default boolean storeNewValues() {
        return false;
    }

    default void deletePassportTranslatedAddress(
        final ProxySession session,
        final AddressId id)
        throws ServerException
    {
    }

    default boolean optional() {
        return false;
    }

    default String name() {
        return this.getClass().toString();
    }
}
