package ru.yandex.passport;

import java.io.IOException;
import java.util.Objects;

import ru.yandex.common.util.region.Region;
import ru.yandex.common.util.region.RegionService;
import ru.yandex.common.util.region.RegionTree;
import ru.yandex.common.util.region.RegionTreePlainTextBuilder;
import ru.yandex.common.util.region.RegionType;
import ru.yandex.passport.address.config.ImmutableRegionBaseConfig;

public class RegionServiceWrapper {
    public volatile static RegionService regionService;

    public RegionServiceWrapper(final AddressProxy proxy) throws IOException {
        ImmutableRegionBaseConfig config = proxy.config().regionBaseConfig();
        //Path.of("region_tree.dump").toUri().toURL()
        RegionService regionService = new RegionService();
        RegionTreePlainTextBuilder regionTreeBuilder = new RegionTreePlainTextBuilder();
        regionTreeBuilder.setPlainTextURL(config.url());
        regionTreeBuilder.setTimeoutMillis(config.timeout());
        regionTreeBuilder.setSkipHeader(true);
        regionTreeBuilder.setSkipUnRootRegions(true);
        regionService.setRegionTreeBuilder(regionTreeBuilder);

        RegionServiceWrapper.regionService = regionService;
        try {
            regionService.updateRegionTree(true, true);
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static RegionServiceWrapper init(final AddressProxy proxy) throws IOException {
        return new RegionServiceWrapper(proxy);
    }

    public static String findRegionName(final Integer regionId) {
        if (regionId == null) {
            return null;
        }
        RegionService regionService = RegionServiceWrapper.regionService;
        @SuppressWarnings("unchecked")
        RegionTree<? extends Region> regionTree = regionService.getRegionTree();
        return regionTree.getPathToRoot(regionId)
            .stream()
            .map(regionTree::getRegion)
            .filter(Objects::nonNull)
            .filter(region -> region.getType() == RegionType.SUBJECT_FEDERATION)
            .findFirst()
            .map(Region::getName).orElse(null);
    }

//    public Integer fetchPreciseRegionId(BigDecimal latitude, BigDecimal longitude, Integer deliveryRegionId) {
//        try {
//            Integer preciseRegion = fetchRegionId(latitude.doubleValue(), longitude.doubleValue());
//            List<Region> pathToRoot = loadPathToRoot(preciseRegion, RegionType.SUBJECT_FEDERATION);
//            if (pathToRoot
//                .stream()
//                .mapToInt(Region::getId)
//                .anyMatch(preciseRegionId -> preciseRegionId == deliveryRegionId)) {
//                logger.info("Successfully fetched precise region id={} ", preciseRegion);
//                return preciseRegion;
//            }
//            logger.warn("Precise region id={} is not a children of deliveryRegionId={}, pathToRoot={}",
//                preciseRegion, deliveryRegionId, pathToRoot);
//            return deliveryRegionId;
//        } catch (Exception e) {
//            logger.error("Failed to fetch precise region id", e);
//        }
//        return null;
//    }
}
