package ru.yandex.passport.address;

import java.io.IOException;
import java.time.OffsetDateTime;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public interface Address extends JsonValue {
    AddressId id();

    AddressService ownerService();

    GeoCoderPoint geoCoderPoint();

    Boolean cargoLift();

    Integer regionId();

    Integer preciseRegionId();

    String country();

    String zip();

    String city();

    String metro();

    String street();

    /**
     * Номер дома
     * @return
     */
    String building();

    /**
     * Подъезд
     * @return
     */
    String entrance();

    String intercom();

    String floor();

    String room();

    String addressLine();

    /**
     * Address subtype (address, bookmark)
     * @return
     */
    String subtype();

    String comment();

    /**
     * Вернуть номер корпуса.
     *
     * @return
     */
    String block();

    /**
     * Вернуть номер владения.
     *
     * @return
     */
    String estate();

    /**
     * Вернуть номер строения.
     *
     * @return
     */
    String wing();

    /**
     * Вернуть километр.
     *
     * @return
     */
    String km();

    /**
     * Вернуть область или регион.
     *
     * @return
     */
    String region();

    /**
     * Вернуть географические координаты
     */
    Location location();

    /**
     * Вернуть статус обновления координат геокодером
     *
     * @return
     */
    GeocoderStatus geocoderStatus();

    /**
     * Вернуть район
     */
    String district();

    /**
     * Вернуть время последнего взаимодействия пользователя с адресом
     */
    OffsetDateTime lastTouchedTime();

    /**
     * Вернуть платформу с которой пользователь создал или изменил адрес
     */
    String platform();

    /**
     * Вернуть статус заполненности адреса
     */
    String fullnessState();

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
//        @JsonProperty("id") @Nullable String id,
//        @JsonProperty("addressId") String addressId,
//        @JsonProperty("regionId") Integer regionId,
//        @JsonProperty("preciseRegionId") Integer preciseRegionId,
//        @JsonProperty("country") String country,
//        @JsonProperty("locality") String city,
//        @JsonProperty("street") String street,
//        @JsonProperty("building") String building,
//        @JsonProperty("floor") String floor,
//        @JsonProperty("room") String room,
//        @JsonProperty("entrance") String entrance,
//        @JsonProperty("intercom") String intercom,
//        @JsonProperty("zip") String zip,
//        @JsonProperty("type") AddressType type,
//        @JsonProperty("comment") String comment,
//        @JsonProperty("location") LocationDto location,
//        @JsonProperty("district") String district,
//        @JsonProperty("lastTouchedTime") @Nullable OffsetDateTime lastTouchedTime,
//        @JsonProperty("fullnessState") AddressFullnessState fullnessState
        AddressDto.write(this, writer);
    }
}
