package ru.yandex.passport.address;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;

import io.vertx.sqlclient.Row;

import ru.yandex.passport.AddressServiceParser;

public class AddressBuilder implements Address {
    protected AddressId id;
    protected AddressService ownerService;
    protected Integer regionId;
    protected Integer preciseRegionId;
    protected String country;
    protected String zip;
    protected String city;
    protected String metro;
    protected String street;
    protected String building;
    protected String entrance;
    protected String intercom;
    protected String floor;
    protected String room;
    protected Boolean cargoLift;
    protected String block;
    protected String estate;
    protected String wing;
    protected String km;
    protected String region;
    protected String addressLine;
    protected String type;
    protected GeoCoderPoint geoCoderPoint;
    protected String comment;
    protected Location location;
    protected GeocoderStatus geocoderStatus;
    protected String district;
    protected OffsetDateTime lastTouchedTime;
    protected String platform;
    protected String fullnessState;
    protected int seqId;

    AddressBuilder() {
    }

    public AddressBuilder setId(final AddressId id) {
        this.id = id;
        return this;
    }

    public AddressBuilder setOwnerService(final AddressService service) {
        this.ownerService = service;
        return this;
    }

    public AddressBuilder setGeoCoderPoint(GeoCoderPoint geoCoderPoint) {
        this.geoCoderPoint = geoCoderPoint;
        return this;
    }

    public AddressBuilder setCargoLift(Boolean cargoLift) {
        this.cargoLift = cargoLift;
        return this;
    }

    public AddressBuilder setBlock(String block) {
        this.block = block;
        return this;
    }

    public AddressBuilder setRegionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    public AddressBuilder setPreciseRegionId(Integer preciseRegionId) {
        this.preciseRegionId = preciseRegionId;
        return this;
    }

    public AddressBuilder setCountry(String country) {
        this.country = country;
        return this;
    }

    public AddressBuilder setZip(String zip) {
        this.zip = zip;
        return this;
    }

    public AddressBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    public AddressBuilder setMetro(String metro) {
        this.metro = metro;
        return this;
    }

    public AddressBuilder setStreet(String street) {
        this.street = street;
        return this;
    }

    public AddressBuilder setBuilding(String building) {
        this.building = building;
        return this;
    }

    public AddressBuilder setEntrance(String entrance) {
        this.entrance = entrance;
        return this;
    }

    public AddressBuilder setIntercom(String intercom) {
        this.intercom = intercom;
        return this;
    }

    public AddressBuilder setFloor(String floor) {
        this.floor = floor;
        return this;
    }

    public AddressBuilder setRoom(String room) {
        this.room = room;
        return this;
    }

    public AddressBuilder setEstate(String estate) {
        this.estate = estate;
        return this;
    }

    public AddressBuilder setWing(String wing) {
        this.wing = wing;
        return this;
    }

    public AddressBuilder setKm(String km) {
        this.km = km;
        return this;
    }

    public AddressBuilder setRegion(String region) {
        this.region = region;
        return this;
    }

    public AddressBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public AddressBuilder setMarketAddressLine(String addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    public AddressBuilder setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public AddressBuilder setLocation(Location location) {
        this.location = location;
        return this;
    }

    public AddressBuilder setGeocoderStatus(GeocoderStatus geocoderStatus) {
        this.geocoderStatus = geocoderStatus;
        return this;
    }

    public AddressBuilder setDistrict(String district) {
        this.district = district;
        return this;
    }

    public AddressBuilder setLastTouchedTime(OffsetDateTime lastTouchedTime) {
        this.lastTouchedTime = lastTouchedTime;
        return this;
    }

    public AddressBuilder setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public AddressBuilder setFullnessState(String fullnessState) {
        this.fullnessState = fullnessState;
        return this;
    }

    public AddressBuilder region(final String region) {
        this.region = region;
        return this;
    }

    @Override
    public AddressId id() {
        return id;
    }

    public int seqId() {
        return seqId;
    }

    @Override
    public AddressService ownerService() {
        return ownerService;
    }

    @Override
    public Integer regionId() {
        return regionId;
    }

    @Override
    public Integer preciseRegionId() {
        return preciseRegionId;
    }

    @Override
    public String country() {
        return country;
    }

    @Override
    public String zip() {
        return zip;
    }

    @Override
    public String city() {
        return city;
    }

    @Override
    public String metro() {
        return metro;
    }

    @Override
    public String street() {
        return street;
    }

    @Override
    public String building() {
        return building;
    }

    @Override
    public String entrance() {
        return entrance;
    }

    @Override
    public String intercom() {
        return intercom;
    }

    @Override
    public String floor() {
        return floor;
    }

    @Override
    public String room() {
        return room;
    }

    @Override
    public Boolean cargoLift() {
        return cargoLift;
    }

    @Override
    public String block() {
        return block;
    }

    @Override
    public String estate() {
        return estate;
    }

    @Override
    public String wing() {
        return wing;
    }

    @Override
    public String km() {
        return km;
    }

    @Override
    public String region() {
        return region;
    }

    @Override
    public String addressLine() {
        return addressLine;
    }

    public String type() {
        return type;
    }

    @Override
    public GeoCoderPoint geoCoderPoint() {
        return geoCoderPoint;
    }

    @Override
    public String comment() {
        return comment;
    }

    @Override
    public Location location() {
        return location;
    }

    @Override
    public GeocoderStatus geocoderStatus() {
        return geocoderStatus;
    }

    @Override
    public String district() {
        return district;
    }

    @Override
    public OffsetDateTime lastTouchedTime() {
        return lastTouchedTime;
    }

    @Override
    public String platform() {
        return platform;
    }

    @Override
    public String fullnessState() {
        return fullnessState;
    }

    @Override
    public String subtype() {
        return type;
    }

    public ImmutableAddress build() {
        return new ImmutableAddress(id, ownerService, regionId, preciseRegionId, country, zip, city, metro, street, building, entrance,
            intercom, floor, room, cargoLift, block, estate, wing, km, region, type, addressLine,
            geoCoderPoint, comment, location, geocoderStatus, district, lastTouchedTime, platform,
            fullnessState);
    }

    @Override
    public String toString() {
        return "AddressBuilder{" +
            "id='" + id + '\'' +
            ", ownerService='" + ownerService + '\'' +
            ", regionId=" + regionId +
            ", preciseRegionId=" + preciseRegionId +
            ", country='" + country + '\'' +
            ", zip='" + zip + '\'' +
            ", city='" + city + '\'' +
            ", metro='" + metro + '\'' +
            ", street='" + street + '\'' +
            ", building='" + building + '\'' +
            ", entrance='" + entrance + '\'' +
            ", intercom='" + intercom + '\'' +
            ", floor='" + floor + '\'' +
            ", room='" + room + '\'' +
            ", cargoLift=" + cargoLift +
            ", block='" + block + '\'' +
            ", estate='" + estate + '\'' +
            ", wing='" + wing + '\'' +
            ", km='" + km + '\'' +
            ", region='" + region + '\'' +
            ", addressLine='" + addressLine + '\'' +
            ", type='" + type + '\'' +
            ", geoCoderPoint=" + geoCoderPoint +
            ", comment='" + comment + '\'' +
            ", location=" + location +
            ", geocoderStatus=" + geocoderStatus +
            ", district='" + district + '\'' +
            ", lastTouchedTime=" + lastTouchedTime +
            ", platform='" + platform + '\'' +
            ", fullnessState='" + fullnessState + '\'' +
            '}';
    }


    public static AddressBuilder build(final PassportAddressUser user, final ResultSet result) throws SQLException {
        return build(user.userType(), user.userId(), result);
    }

    public static AddressBuilder build(final PassportAddressUser user, final Row result) throws SQLException {
        return build(user.userType(), user.userId(), result);
    }

    public static AddressBuilder build(
        final String userType,
        final Object userId,
        final Row result)
        throws SQLException
    {
        AddressBuilder builder = new AddressBuilder();
        builder.setRegionId(result.getInteger("region_id"));
        builder.setCountry(result.getString("country"));
        builder.setZip(result.getString("zip"));
        builder.setCity(result.getString("city"));
        String ownerServiceName = result.getString("owner_service");
        builder.setOwnerService(AddressServiceParser.INSTANCE.apply(ownerServiceName));
        builder.setType("address");
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street"));
        builder.setBuilding(result.getString("building"));
        builder.setIntercom(result.getString("intercom"));
        builder.setFloor(result.getString("floor"));
        builder.setRoom(result.getString("room"));
        //builder.setCargoLift(result.getBoolean("ca"))
        builder.setLocation(
            new Location(
                result.getBigDecimal("latitude"),
                result.getBigDecimal("longitude")));
        builder.setDistrict(result.getString("district"));
        builder.setLastTouchedTime(result.getOffsetDateTime("last_touched_time"));
        builder.setId(
            new AddressId(userType, userId, builder.ownerService(), result.getString("address_id")));
        return builder;
    }

    public static AddressBuilder build(
        final String userType,
        final Object userId,
        final ResultSet result)
        throws SQLException
    {
        AddressBuilder builder = new AddressBuilder();
        builder.setRegionId((Integer) result.getObject("region_id"));
        builder.setCountry(result.getString("country"));
        builder.setZip(result.getString("zip"));
        builder.setCity(result.getString("city"));
        String ownerServiceName = result.getString("owner_service");
        builder.setOwnerService(AddressServiceParser.INSTANCE.apply(ownerServiceName));
        builder.setType("address");
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street"));
        builder.setBuilding(result.getString("building"));
        builder.setIntercom(result.getString("intercom"));
        builder.setFloor(result.getString("floor"));
        builder.setRoom(result.getString("room"));
        //builder.setCargoLift(result.getBoolean("ca"))
        builder.setLocation(
            new Location(
                result.getBigDecimal("latitude"),
                result.getBigDecimal("longitude")));
        builder.setDistrict(result.getString("district"));
        builder.setLastTouchedTime(result.getObject("last_touched_time", OffsetDateTime.class));
        builder.setId(
            new AddressId(userType, userId, builder.ownerService(), result.getString("address_id")));
        return builder;
    }
}
