package ru.yandex.passport.address;

import java.io.IOException;
import java.math.BigDecimal;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.AddressContext;

public class AddressDto {
    public static void write(
        final Address address,
        final JsonWriterBase writer)
        throws IOException
    {
        writer.key("id");
        writer.value(address.id());
        writer.key("owner_service");
        writer.value(address.ownerService());
        writer.key("type");
        writer.value(address.subtype());
        writer.key("subtype");
        writer.value(address.subtype());
        writer.key("building");
        writer.value(address.building());
        writer.key("comment");
        writer.value(address.comment());
        writer.key("country");
        writer.value(address.country());
        writer.key("district");
        writer.value(address.district());
        writer.key("entrance");
        writer.value(address.entrance());
        writer.key("floor");
        writer.value(address.floor());
        writer.key("intercom");
        writer.value(address.intercom());
        writer.key("city");
        writer.value(address.city());
        writer.key("locality");
        writer.value(address.city());
        writer.key("location");
        writer.value(address.location());
        writer.key("regionId");
        writer.value(address.regionId());
        writer.key("region");
        writer.value(address.region());
        writer.key("room");
        writer.value(address.room());
        writer.key("street");
        writer.value(address.street());
        writer.key("zip");
        writer.value(address.zip());
    }

    public static AddressBuilder parseForCreate(
        final AddressContext context,
        final JsonMap result)
        throws JsonException
    {
        AddressBuilder builder = new AddressBuilder();
        String addressLine = result.getString("address_line", null);
        builder.setMarketAddressLine(addressLine);
        builder.setRegionId(result.getInt("regionId", null));
        builder.setPreciseRegionId(builder.regionId());
        builder.setCountry(result.getString("country", null));
        builder.setZip(result.getString("zip", null));
        String city = result.getString("locality", null);
        if (city == null) {
            city = result.getString("city", null);
        }
        builder.setCity(city);
        builder.setOwnerService(context.service());
        builder.setType(result.getString("subtype", "address"));
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street", null));
        builder.setBuilding(result.getString("building", null));
        builder.setIntercom(result.getString("intercom", null));
        builder.setFloor(result.getString("floor", null));
        builder.setRoom(result.getString("room", null));
        //builder.setCargoLift(result.getBoolean("ca"))

        JsonMap locationMap = result.getMapOrNull("location");
        if (locationMap != null) {
            builder.setLocation(
                new Location(
                    BigDecimal.valueOf(locationMap.getDouble("latitude")),
                    BigDecimal.valueOf(locationMap.getDouble("longitude"))));
        } else {
            builder.setLocation(null);
        }

        builder.setDistrict(result.getString("district", null));
        return builder;
    }
}
