package ru.yandex.passport.address;

import java.util.Locale;

import ru.yandex.passport.address.filters.YandexPayAddressFilter;

public enum AddressService {
    PAY(YandexPayAddressFilter.INSTANCE),
    PASSPORT,
    PASSPORT_DELIVERY,
    MAPS,
    MARKET,
    TAXI,
    USLUGI,
    EDA,
    TOOLS_TRIP,
    UNKNOWN;

    private final String serviceName;
    private final AddressFilter addressFilter;

    AddressService() {
        this(AddressFilter.ACCEPT_ALL);
    }

    AddressService(final AddressFilter addressFilter) {
        this.serviceName = name().toLowerCase(Locale.ENGLISH);
        this.addressFilter = addressFilter;
    }

    public String serviceName() {
        return serviceName;
    }

    public AddressFilter addressFilter() {
        return addressFilter;
    }

    @Override
    public String toString() {
        return serviceName;
    }
}
