package ru.yandex.passport.address;

import java.util.Objects;

public class GeoCoderPoint {
    private final String longitude;
    private final String latitude;

    public GeoCoderPoint(String pointFromResponse) {
        String[] split = pointFromResponse.split(" ");
        this.longitude = split[0];
        this.latitude = split[1];
    }

    public GeoCoderPoint(String longitude, String latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public String getLongitude() {
        return longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof GeoCoderPoint)) {
            return false;
        }
        GeoCoderPoint point = (GeoCoderPoint) o;
        return Objects.equals(longitude, point.longitude) &&
            Objects.equals(latitude, point.latitude);
    }

    @Override
    public int hashCode() {

        return Objects.hash(longitude, latitude);
    }

    @Override
    public String toString() {
        return "GeoCoderPoint{" +
            "longitude='" + longitude + '\'' +
            ", latitude='" + latitude + '\'' +
            '}';
    }
}
